<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'pegawai') {
    header("Location: login.php");
    exit;
}
include 'database/koneksi.php';

$kasir_id = $_SESSION['user_id'];
$tanggal = isset($_GET['tanggal']) && $_GET['tanggal'] != '' ? $_GET['tanggal'] : date('Y-m-d');

// Ringkasan transaksi
$q1 = mysqli_query($conn, "
  SELECT
    COUNT(DISTINCT t.id) AS jumlah_transaksi,
    SUM(dt.subtotal) AS total_penjualan
  FROM transaksi t
  JOIN detail_transaksi dt ON dt.transaksi_id = t.id
  WHERE t.kasir_id = '$kasir_id' AND DATE(t.waktu_transaksi) = '$tanggal'
");
$data1 = mysqli_fetch_assoc($q1);

// Total per metode pembayaran
$q_summary = mysqli_query($conn, "
  SELECT
    SUM(CASE WHEN metode = 'QRIS' THEN total ELSE 0 END) AS total_qris,
    SUM(CASE WHEN metode = 'Tunai' THEN total ELSE 0 END) AS total_tunai
  FROM transaksi
  WHERE kasir_id = '$kasir_id' AND DATE(waktu_transaksi) = '$tanggal'
");
$summary = mysqli_fetch_assoc($q_summary);

// Detail metode pembayaran
$q2 = mysqli_query($conn, "
  SELECT metode, COUNT(*) as jumlah, SUM(total) as total
  FROM transaksi
  WHERE kasir_id = '$kasir_id' AND DATE(waktu_transaksi) = '$tanggal'
  GROUP BY metode
");

// Semua menu dan jumlah terjual
$q_per_menu = mysqli_query($conn, "
  SELECT
    m.nama_menu,
    SUM(dt.jumlah) AS total_terjual,
    SUM(dt.subtotal) AS total_penjualan
  FROM detail_transaksi dt
  JOIN transaksi t ON t.id = dt.transaksi_id
  JOIN menu m ON m.id = dt.menu_id
  WHERE t.kasir_id = '$kasir_id' AND DATE(t.waktu_transaksi) = '$tanggal'
  GROUP BY m.id
  HAVING total_terjual > 0
  ORDER BY total_penjualan DESC
");

// $q_per_menu = mysqli_query($conn, "
//   SELECT
//     m.nama_menu,
//     COALESCE(SUM(CASE WHEN DATE(t.waktu_transaksi) = '$tanggal' THEN dt.jumlah ELSE 0 END), 0) AS total_terjual,
//     COALESCE(SUM(CASE WHEN DATE(t.waktu_transaksi) = '$tanggal' THEN dt.subtotal ELSE 0 END), 0) AS total_penjualan
//   FROM menu m
//   LEFT JOIN detail_transaksi dt ON m.id = dt.menu_id
//   LEFT JOIN transaksi t ON t.id = dt.transaksi_id AND t.kasir_id = '$kasir_id'
//   GROUP BY m.id
//   ORDER BY total_penjualan DESC
// ");

// Total menu terjual
$q_total_menu = mysqli_query($conn, "
  SELECT SUM(dt.jumlah) AS total_menu_terjual
  FROM transaksi t
  JOIN detail_transaksi dt ON dt.transaksi_id = t.id
  WHERE t.kasir_id = '$kasir_id' AND DATE(t.waktu_transaksi) = '$tanggal'
");
$data_menu = mysqli_fetch_assoc($q_total_menu);
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Closing Penjualan</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/r_kasir.css">
  <link rel="stylesheet" href="assets/css/kasir_unified.css">
  <style>
    .toast-success {
      position: fixed;
      bottom: 20px;
      right: 20px;
      background: #198754;
      color: white;
      padding: 10px 15px;
      border-radius: 8px;
      display: none;
      box-shadow: 0 3px 10px rgba(0,0,0,0.2);
      animation: fadeInOut 3s ease forwards;
    }

    @keyframes fadeInOut {
      0% { opacity: 0; transform: translateY(20px); }
      10%,90% { opacity: 1; transform: translateY(0); }
      100% { opacity: 0; transform: translateY(20px); }
    }
  </style>
</head>
<body>
  <button class="btn-toggle-sidebar" onclick="toggleSidebar()">☰ Menu</button>
  <?php include 'layout/sidebar.php'; ?>

  <div class="main-container">
    <div class="content">
      <h3 class="mb-4">📊 Closing Penjualan - <?= htmlspecialchars($_SESSION['username']) ?> (<?= $tanggal ?>)</h3>

      <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
          <input type="date" name="tanggal" class="form-control" value="<?= htmlspecialchars($tanggal) ?>">
        </div>
        <div class="col-md-2">
          <button class="btn btn-custom w-100">Tampilkan</button>
        </div>
      </form>

      <!-- RINGKASAN -->
      <div class="summary-card">
        <h5 class="summary-title">Ringkasan</h5>
        <div class="summary-grid">
          <div class="summary-item">
            <div class="summary-label">Total Penjualan</div>
            <div class="summary-value">Rp <?= number_format($data1['total_penjualan'] ?? 0, 0, ',', '.') ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Jumlah Transaksi</div>
            <div class="summary-value"><?= $data1['jumlah_transaksi'] ?? 0 ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Total QRIS</div>
            <div class="summary-value">Rp <?= number_format($summary['total_qris'] ?? 0, 0, ',', '.') ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Total Tunai</div>
            <div class="summary-value">Rp <?= number_format($summary['total_tunai'] ?? 0, 0, ',', '.') ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Jumlah Menu Terjual</div>
            <div class="summary-value"><?= $data_menu['total_menu_terjual'] ?? 0 ?></div>
          </div>
        </div>
      </div>

      <!-- DETAIL METODE PEMBAYARAN -->
      <div class="card shadow-sm mb-4">
        <div class="card-body">
          <h5 class="card-title">Detail Metode Pembayaran</h5>
          <ul class="list-group">
            <?php while ($row = mysqli_fetch_assoc($q2)) { ?>
              <li class="list-group-item d-flex justify-content-between">
                <?= htmlspecialchars($row['metode']) ?>
                <span><?= $row['jumlah'] ?>x - Rp <?= number_format($row['total'], 0, ',', '.') ?></span>
              </li>
            <?php } ?>
          </ul>
        </div>
      </div>

      <!-- DAFTAR MENU -->
      <div class="card shadow-sm mb-4">
        <div class="card-body">
          <h5 class="card-title">Daftar Menu dan Jumlah Terjual</h5>
          <div class="table-responsive">
            <table class="table table-bordered table-sm">
              <thead class="table-light">
                <tr>
                  <th>Nama Menu</th>
                  <th>Jumlah Terjual</th>
                  <th>Total Penjualan</th>
                </tr>
              </thead>
              <tbody>
                <?php while ($row = mysqli_fetch_assoc($q_per_menu)) { ?>
                  <tr>
                    <td><?= htmlspecialchars($row['nama_menu']) ?></td>
                    <td><?= $row['total_terjual'] ?>x</td>
                    <td>Rp <?= number_format($row['total_penjualan'], 0, ',', '.') ?></td>
                  </tr>
                <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- TOMBOL & COPY TEKS -->
      <div class="text-end mb-3">
        <button id="btnClosing" class="btn btn-success">✅ Closing Kasir</button>
      </div>

      <div class="text-end">
        <a href="kasir.php" class="btn btn-outline-dark">⬅️ Kembali ke Kasir</a>
      </div>
    </div>
  </div>

  <!-- Toast -->
  <div id="toast" class="toast-success">Laporan berhasil disalin ✅</div>

  <script>
    document.getElementById('btnClosing').addEventListener('click', function() {
      const laporan = `
<?= $tanggal ?>


Total Pendapatan: Rp <?= number_format($data1['total_penjualan'] ?? 0, 0, ',', '.') ?>

Total Tunai: Rp <?= number_format($summary['total_tunai'] ?? 0, 0, ',', '.') ?>

Total QRIS: Rp <?= number_format($summary['total_qris'] ?? 0, 0, ',', '.') ?>

Jumlah Cup: <?= $data_menu['total_menu_terjual'] ?? 0 ?> Pcs
Rincian Menu:
<?php
mysqli_data_seek($q_per_menu, 0);
while ($row = mysqli_fetch_assoc($q_per_menu)) {
  echo "- " . $row['nama_menu'] . " x" . $row['total_terjual'] . " = Rp " . number_format($row['total_penjualan'], 0, ',', '.') . "\\n";
}
?>
      `;
      navigator.clipboard.writeText(laporan).then(() => {
        const toast = document.getElementById('toast');
        toast.style.display = 'block';
        setTimeout(() => toast.style.display = 'none', 3000);
      });
    });

    function toggleSidebar() {
      document.querySelector('.sidebar').classList.toggle('active');
    }
  </script>

</body>
</html>
