let total = 0;
let orders = [];
let isProcessing = false; // Cegah double submit

// 🛒 Tambah pesanan
function tambahPesanan(id, nama, harga) {
  const existing = orders.find(item => item.id === id);
  if (existing) {
    existing.qty++;
  } else {
    orders.push({ id, nama, harga, qty: 1 });
  }
  renderOrder();
}

// ➖ Kurangi pesanan
function kurangPesanan(id) {
  const existing = orders.find(item => item.id === id);
  if (existing) {
    existing.qty--;
    if (existing.qty <= 0) hapusPesanan(id);
  }
  renderOrder();
}

// ❌ Hapus pesanan
function hapusPesanan(id) {
  orders = orders.filter(item => item.id !== id);
  renderOrder();
}

// 🔄 Render daftar pesanan
function renderOrder() {
  const orderList = document.getElementById("orderList");
  orderList.innerHTML = "";
  total = 0;

  orders.forEach(item => {
    const subtotal = item.harga * item.qty;
    total += subtotal;
    orderList.innerHTML += `
      <div class="order-item fade-in">
        <div class="order-item-info">
          <div class="order-item-name">${item.nama}</div>
          <div class="order-item-price">Rp ${item.harga.toLocaleString('id-ID')}</div>
        </div>
        <div class="order-item-controls">
          <button class="qty-btn" onclick="kurangPesanan(${item.id})">-</button>
          <span class="qty-display">${item.qty}</span>
          <button class="qty-btn" onclick="tambahPesanan(${item.id}, '${item.nama}', ${item.harga})">+</button>
          <span class="order-item-price">Rp ${subtotal.toLocaleString('id-ID')}</span>
          <button class="qty-btn" onclick="hapusPesanan(${item.id})" style="background-color: var(--error);">
            <i class='fas fa-times'></i>
          </button>
        </div>
      </div>`;
  });

  document.getElementById("total").innerText = total.toLocaleString('id-ID');
  hitungKembalian();
}

// 💵 Hitung kembalian
function hitungKembalian() {
  const uang = parseInt(document.getElementById("uang").value) || 0;
  const kembali = uang - total;
  const tampil = document.getElementById("kembalian");

  if (uang === 0 && total === 0) {
    tampil.classList.remove('show');
    tampil.innerText = "";
    return;
  }

  tampil.classList.add('show');
  if (kembali >= 0) {
    tampil.innerText = "Kembalian: Rp " + kembali.toLocaleString('id-ID');
    tampil.style.backgroundColor = 'var(--success)';
  } else {
    tampil.innerText = "Kurang: Rp " + Math.abs(kembali).toLocaleString('id-ID');
    tampil.style.backgroundColor = 'var(--error)';
  }
}

// 🔔 Toast Notifikasi
function showToast(msg, type = "success") {
  const toast = document.createElement("div");
  toast.className = `toast ${type}`;
  toast.textContent = msg;
  document.body.appendChild(toast);

  setTimeout(() => toast.classList.add("show"), 100);
  setTimeout(() => {
    toast.classList.remove("show");
    setTimeout(() => toast.remove(), 300);
  }, 2500);
}

// 💳 Proses Pembayaran
function bayar() {
  const metode = document.getElementById("metode_pembayaran").value;
  const uang = parseInt(document.getElementById("uang").value) || 0;
  const kembali = uang - total;
  const catatan = document.getElementById("catatan").value.trim();
  const btnBayar = document.querySelector(".bayar-btn");

  if (orders.length === 0) {
    showToast("Belum ada menu yang dipesan.", "error");
    return;
  }

  if (metode === "Tunai" && uang < total) {
    showToast("Uang tidak cukup untuk pembayaran.", "error");
    return;
  }

  if (isProcessing) {
    showToast("Sedang memproses transaksi...", "info");
    return;
  }

  isProcessing = true;
  btnBayar.disabled = true;
  btnBayar.innerHTML = `<i class="fas fa-spinner fa-spin"></i> Memproses...`;

  const items = orders.map(item => ({
    menu_id: item.id,
    jumlah: item.qty,
    subtotal: item.harga * item.qty
  }));

  // 🟢 Kirim data ke server
  fetch("proses.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({
      total: total,
      bayar: uang,
      kembalian: kembali,
      metode: metode,
      catatan: catatan,
      items: items
    })
  })
    .then(res => res.json())
    .then(res => {
      if (res.success) {
        showToast("✅ Transaksi berhasil! Mencetak struk...", "success");

        // Reset semua input
        orders = [];
        total = 0;
        document.getElementById("uang").value = "";
        document.getElementById("kembalian").innerText = "";
        document.getElementById("catatan").value = "";
        renderOrder();

        // Redirect ke struk
        setTimeout(() => {
          if (res.id_transaksi) {
            window.location.href = `struk.php?id=${res.id_transaksi}`;
          } else {
            window.location.reload();
          }
          isProcessing = false;
          btnBayar.disabled = false;
          btnBayar.innerHTML = "💸 Bayar Sekarang";
        }, 1500);
      } else {
        showToast("❌ Gagal menyimpan transaksi: " + res.message, "error");
        isProcessing = false;
        btnBayar.disabled = false;
        btnBayar.innerHTML = "💸 Bayar Sekarang";
      }
    })
    .catch(err => {
      console.error(err);
      showToast("❌ Terjadi kesalahan saat menyimpan transaksi.", "error");
      isProcessing = false;
      btnBayar.disabled = false;
      btnBayar.innerHTML = "💸 Bayar Sekarang";
    });
}

// 🔍 Pencarian Menu
document.getElementById("searchMenu").addEventListener("keyup", function () {
  const keyword = this.value.toLowerCase();
  const cards = document.querySelectorAll(".menu-card");
  cards.forEach(card => {
    const title = card.querySelector("h4").textContent.toLowerCase();
    card.style.display = title.includes(keyword) ? "flex" : "none";
  });
});

// 💰 Ganti metode pembayaran
document.getElementById("metode_pembayaran").addEventListener("change", function () {
  const metode = this.value;
  const totalText = document.getElementById("total").textContent.replace(/\./g, '');
  const totalNum = Number(totalText) || 0;

  if (metode === "QRIS") {
    document.getElementById("uang").value = totalNum;
  } else {
    document.getElementById("uang").value = "";
  }
  hitungKembalian();
});

// 🚀 Urutkan menu abjad saat load
window.addEventListener("DOMContentLoaded", () => {
  const grid = document.querySelector(".grid");
  const cards = Array.from(grid.querySelectorAll(".menu-card"));
  cards.sort((a, b) => a.querySelector("h4").textContent.localeCompare(b.querySelector("h4").textContent));
  cards.forEach(card => grid.appendChild(card));
  renderOrder();
});
