<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit;
}
include '../database/koneksi.php';

// Tambah user
if (isset($_POST['tambah'])) {
    $username = trim($_POST['username']);
    $password = md5(trim($_POST['password']));
    $role     = $_POST['role'];

    // Validasi input
    if (empty($username) || empty($password)) {
        $error = "Username dan password tidak boleh kosong.";
    } else {
        mysqli_query($conn, "INSERT INTO users (username, password, role) VALUES ('$username', '$password', '$role')");
        $success = "User  berhasil ditambahkan.";
    }
}

// Hapus user
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    mysqli_query($conn, "DELETE FROM users WHERE id='$id'");
    $success = "User  berhasil dihapus.";
}

// Ambil data user
$users_per_page = 5; // Jumlah user per halaman
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $users_per_page;

$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$search_query = $search ? "WHERE username LIKE '%$search%'" : '';
$users = mysqli_query($conn, "SELECT * FROM users $search_query ORDER BY id DESC LIMIT $users_per_page OFFSET $offset");
$total_users = mysqli_query($conn, "SELECT COUNT(*) as count FROM users $search_query");
$total_users_count = mysqli_fetch_assoc($total_users)['count'];
$total_pages = ceil($total_users_count / $users_per_page);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen User - 1Parade</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/kasir_unified.css"> <!-- Gunakan CSS yang sama -->
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
        }
        .main-container {
            display: flex;
            flex-direction: column;
            padding: 20px;
        }
        .content {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .section-title {
            font-size: 2rem;
            font-weight: 600;
            color: #7a4b32; /* Warna aksen kopi */
            margin-bottom: 20px;
        }
        .card {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .form-control {
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            width: 100%;
            margin-bottom: 10px;
        }
        .btn-add-user {
            background-color: #7a4b32; /* Warna aksen kopi */
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            font-size: 16px;
            width: 100%;
        }
        .btn-add-user:hover {
            background-color: #6b3e2a; /* Warna lebih gelap saat hover */
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .table th, .table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        .table th {
            background-color: #7a4b32; /* Warna aksen kopi */
            color: white;
        }
        .table tbody tr:hover {
            background-color: #f1f1f1;
        }
        @media (max-width: 768px) {
            .form-control {
                font-size: 14px;
            }
            .btn-add-user {
                font-size: 14px;
            }
            .table th, .table td {
                font-size: 14px;
            }
            .section-title {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <button class="btn-toggle-sidebar" onclick="toggleSidebar()">☰ Menu</button>
    <?php include '../layout/sidebar-admin.php'; ?> <!-- Include sidebar admin -->

    <div class="main-container">
        <div class="content">
            <h2 class="section-title">👥 Manajemen User</h2>

            <!-- Notifikasi -->
            <?php if (isset($success)): ?>
                <div class="alert alert-success"><?= $success ?></div>
            <?php endif; ?>
            <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?= $error ?></div>
            <?php endif; ?>

            <!-- Form Tambah User -->
            <div class="card">
                <h5 class="card-title">Tambah User</h5>
                <form method="POST" class="row g-3 mb-4">
                    <div class="col-md-4">
                        <input type="text" name="username" class="form-control" placeholder="Username" required>
                    </div>
                    <div class="col-md-4">
                        <input type="password" name="password" class="form-control" placeholder="Password" required>
                    </div>
                    <div class="col-md-4">
                        <select name="role" class="form-select" required>
                            <option value="pegawai">Pegawai (Kasir)</option>
                            <option value="admin">Admin</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <button class="btn-add-user" name="tambah">Tambah</button>
                    </div>
                </form>
            </div>

            <!-- Pencarian User -->
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-8">
                    <input type="text" name="search" class="form-control" placeholder="Cari user..." value="<?= htmlspecialchars($search) ?>">
                </div>
                <div class="col-md-4">
                    <button class="btn btn-dark w-100">Cari</button>
                </div>
            </form>

            <!-- Tabel Daftar User -->
            <div class="card">
                <h5 class="card-title">Daftar User</h5>
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Username</th>
                            <th>Role</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; while ($row = mysqli_fetch_assoc($users)) { ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= htmlspecialchars($row['username']) ?></td>
                            <td><?= htmlspecialchars($row['role']) ?></td>
                            <td>
                                <a href="users.php?hapus=<?= $row['id'] ?>" onclick="return confirm('Hapus user ini?')" class="btn btn-sm btn-danger">Hapus</a>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>


        </div>
    </div>

    <script>
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>
