<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit;
}
include '../database/koneksi.php';

$tanggal = $_GET['tanggal'] ?? date('Y-m-d');

$q_ringkasan = mysqli_query($conn, "
    SELECT
        COUNT(DISTINCT t.id) AS jumlah_transaksi,
        SUM(dt.subtotal) AS total_omzet
    FROM transaksi t
    JOIN detail_transaksi dt ON dt.transaksi_id = t.id
    WHERE DATE(t.waktu_transaksi) = '$tanggal'
");
$ringkasan = mysqli_fetch_assoc($q_ringkasan);

$q_metode = mysqli_query($conn, "
    SELECT
        metode,
        COUNT(*) AS jumlah,
        SUM(total) AS total_per_metode
    FROM transaksi
    WHERE DATE(waktu_transaksi) = '$tanggal'
    GROUP BY metode
");

$q_total_menu = mysqli_query($conn, "
    SELECT SUM(dt.jumlah) AS total_menu_terjual
    FROM transaksi t
    JOIN detail_transaksi dt ON dt.transaksi_id = t.id
    WHERE DATE(t.waktu_transaksi) = '$tanggal'
");
$total_menu = mysqli_fetch_assoc($q_total_menu);

$q_rekap_menu = mysqli_query($conn, "
    SELECT m.nama_menu,
           SUM(dt.jumlah) AS total_terjual,
           SUM(dt.subtotal) AS total_penjualan
    FROM transaksi t
    JOIN detail_transaksi dt ON dt.transaksi_id = t.id
    JOIN menu m ON m.id = dt.menu_id
    WHERE DATE(t.waktu_transaksi) = '$tanggal'
    GROUP BY dt.menu_id
    ORDER BY total_penjualan DESC
");

$q_transaksi = mysqli_query($conn, "
    SELECT t.*, u.username
    FROM transaksi t
    JOIN users u ON u.id = t.kasir_id
    WHERE DATE(t.waktu_transaksi) = '$tanggal'
    ORDER BY t.waktu_transaksi DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Laporan Penjualan Harian - Admin 1Parade</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <link rel="stylesheet" href="../assets/css/kasir_unified.css" />
    <style>
        /* Ringkasan */
        .ringkasan {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 2rem;
        }
        .card-ringkasan {
            flex: 1 1 250px;
            background: var(--white);
            border-radius: var(--border-radius);
            padding: 1rem 1.5rem;
            box-shadow: var(--shadow-light);
            color: var(--cafe-dark);
            font-weight: 600;
            text-align: center;
            transition: var(--transition-smooth);
        }
        .card-ringkasan p {
            font-size: 1.25rem;
            margin: 0.3rem 0;
        }
        .card-ringkasan:hover {
            box-shadow: var(--shadow-medium);
            transform: translateY(-3px);
        }

        /* Table rekap menu */
        .table-responsive {
            border-radius: var(--border-radius);
            box-shadow: var(--shadow-light);
            overflow-x: auto;
            background: var(--white);
        }
        table.table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        table.table th,
        table.table td {
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #ddd;
            vertical-align: middle;
        }
        table.table thead tr {
            background-color: var(--cafe-dark);
            color: var(--white);
        }
        table.table tfoot tr {
            background-color: var(--cafe-light);
            font-weight: 700;
            color: var(--cafe-dark);
        }

        /* Card Header transaksi */
        .card-header {
            background: var(--cafe-light);
            color: var(--cafe-dark);
            font-weight: 700;
            padding: 0.75rem 1.5rem;
            border-bottom: 1px solid #ccc;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top-left-radius: var(--border-radius);
            border-top-right-radius: var(--border-radius);
        }
        .card-header span {
            font-weight: 500;
            font-size: 0.9rem;
            color: var(--text-medium);
        }

        /* List group item transaksi */
        .list-group-item {
            display: flex;
            justify-content: space-between;
            padding: 0.8rem 1.5rem;
            font-weight: 600;
            color: var(--text-dark);
            border: none;
            border-bottom: 1px solid #eee;
            transition: background-color 0.3s ease;
            cursor: default;
        }
        .list-group-item:hover {
            background-color: var(--cafe-light);
        }

        /* Card body padding */
        .card-body {
            padding: 1rem 1.5rem 1.5rem;
        }

        /* Total penjualan hari ini */
        .alert.alert-success {
            background-color: var(--success);
            color: var(--white);
            font-weight: 700;
            font-size: 1.3rem;
            border-radius: var(--border-radius);
            padding: 1rem;
            box-shadow: var(--shadow-medium);
            transition: var(--transition-smooth);
            margin-top: 2rem;
        }
        .alert.alert-success:hover {
            box-shadow: var(--shadow-heavy);
            transform: translateY(-3px);
        }

        /* Responsive tweaks */
        @media (max-width: 768px) {
            .card-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.3rem;
                font-size: 0.95rem;
            }
            .card-header span {
                align-self: flex-end;
                font-size: 0.85rem;
                color: var(--text-medium);
            }
        }
    </style>
</head>
<body>
    <button class="btn-toggle-sidebar" onclick="toggleSidebar()">☰ Menu</button>
    <?php include '../layout/sidebar-admin.php'; ?>

    <div class="main-container">
        <div class="content">
            <h2 class="section-title">📊 Laporan Penjualan Harian</h2>

              <form method="GET" class="filter-form">
  <div class="col-12 col-md-6">
    <label for="tanggal">📅 Pilih Tanggal</label>
    <input type="date" id="tanggal" name="tanggal" value="<?= htmlspecialchars($tanggal) ?>" />
  </div>
  <div class="col-12 col-md-3">
    <button class="btn-gold">🔍 Tampilkan</button>
  </div>
</form>



            <!-- Ringkasan -->
            <div class="ringkasan">
                <div class="card-ringkasan">
                    <p>Total Transaksi:</p>
                    <p><?= $ringkasan['jumlah_transaksi'] ?? 0 ?></p>
                </div>
                <div class="card-ringkasan">
                    <p>Total Omzet:</p>
                    <p>Rp <?= number_format($ringkasan['total_omzet'] ?? 0, 0, ',', '.') ?></p>
                </div>
                <div class="card-ringkasan">
                    <p>Total Menu Terjual:</p>
                    <p><?= $total_menu['total_menu_terjual'] ?? 0 ?></p>
                </div>
                <?php while ($m = mysqli_fetch_assoc($q_metode)) : ?>
                <div class="card-ringkasan">
                    <p>Total <?= htmlspecialchars($m['metode']) ?>:</p>
                    <p>Rp <?= number_format($m['total_per_metode'], 0, ',', '.') ?></p>
                </div>
                <?php endwhile; ?>
            </div>

            <!-- Rekap Penjualan Menu -->
            <h3>📦 Rekap Penjualan Menu</h3>
            <div class="table-responsive mb-5">
                <table class="table table-bordered table-striped bg-white">
                    <thead>
                        <tr>
                            <th>Nama Menu</th>
                            <th>Jumlah Terjual</th>
                            <th>Total Penjualan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $grand_total = 0;
                        mysqli_data_seek($q_rekap_menu, 0);
                        while ($rm = mysqli_fetch_assoc($q_rekap_menu)) {
                            $grand_total += $rm['total_penjualan'];
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($rm['nama_menu']) ?></td>
                            <td><?= $rm['total_terjual'] ?></td>
                            <td>Rp <?= number_format($rm['total_penjualan'], 0, ',', '.') ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2" class="fw-bold">Total Omzet Menu</td>
                            <td class="fw-bold">Rp <?= number_format($grand_total, 0, ',', '.') ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Daftar Transaksi Detail -->
            <h3>🧾 Daftar Transaksi</h3>
            <?php
            $total_hari_ini = 0;
            mysqli_data_seek($q_transaksi, 0);
            while ($trx = mysqli_fetch_assoc($q_transaksi)) {
                $total_hari_ini += $trx['total'];
            ?>
            <div class="card mb-3 shadow-sm">
                <div class="card-header">
                    #<?= htmlspecialchars($trx['id']) ?> - Rp <?= number_format($trx['total'], 0, ',', '.') ?>
                    <span>
                        <?= htmlspecialchars($trx['username']) ?> | <?= htmlspecialchars($trx['metode']) ?> | <?= date('H:i', strtotime($trx['waktu_transaksi'])) ?>
                    </span>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <?php
                        $detail = mysqli_query($conn, "
                            SELECT dt.*, m.nama_menu
                            FROM detail_transaksi dt
                            JOIN menu m ON m.id = dt.menu_id
                            WHERE dt.transaksi_id = {$trx['id']}
                        ");
                        while ($d = mysqli_fetch_assoc($detail)) {
                        ?>
                        <li class="list-group-item">
                            <?= htmlspecialchars($d['nama_menu']) ?> x<?= htmlspecialchars($d['jumlah']) ?>
                            <span>Rp <?= number_format($d['subtotal'], 0, ',', '.') ?></span>
                        </li>
                        <?php } ?>
                    </ul>
                    <div class="mt-3 text-end small text-muted">
                        Bayar: Rp <?= number_format($trx['bayar'], 0, ',', '.') ?> |
                        Kembali: Rp <?= number_format($trx['kembalian'], 0, ',', '.') ?>
                    </div>
                </div>
            </div>
            <?php } ?>

            <div class="alert alert-success mt-4 text-center">
                <strong>Total Penjualan Hari Ini:</strong> Rp <?= number_format($total_hari_ini, 0, ',', '.') ?>
            </div>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>
