<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit;
}
include '../database/koneksi.php';

// Periode bulan ini
$bulan_ini = date('Y-m-01');
$hari_terakhir = date('Y-m-t');

// Total transaksi bulan ini
$q_transaksi = mysqli_query($conn, "
    SELECT COUNT(DISTINCT id) AS total_transaksi
    FROM transaksi
    WHERE DATE(waktu_transaksi) BETWEEN '$bulan_ini' AND '$hari_terakhir'
");
$trx = mysqli_fetch_assoc($q_transaksi);

// Total omzet bulan ini
$q_omzet = mysqli_query($conn, "
    SELECT SUM(dt.subtotal) AS total_omzet
    FROM transaksi t
    JOIN detail_transaksi dt ON t.id = dt.transaksi_id
    WHERE DATE(waktu_transaksi) BETWEEN '$bulan_ini' AND '$hari_terakhir'
");
$omzet = mysqli_fetch_assoc($q_omzet);

// Total kasir (role pegawai)
$q_user = mysqli_query($conn, "SELECT COUNT(*) AS total_user FROM users WHERE role = 'pegawai'");
$user = mysqli_fetch_assoc($q_user);

// Total menu tersedia
$q_menu = mysqli_query($conn, "SELECT COUNT(*) AS total_menu FROM menu");
$menu = mysqli_fetch_assoc($q_menu);
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Dashboard 1parade Coffee</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="../assets/css/kasir_unified.css"> <!-- Gunakan CSS yang sama -->
  <style>
    /* Tambahan CSS untuk tampilan yang lebih baik */
    .stat-box {
      display: flex;
      flex-wrap: wrap; /* Membuat responsif */
      justify-content: space-between;
      gap: 20px;
      margin-bottom: 2rem;
    }

    .card-stat {
      background: var(--white);
      border-radius: var(--border-radius-lg);
      box-shadow: var(--shadow-light);
      padding: 1.5rem;
      flex: 1 1 calc(25% - 20px); /* Responsif untuk 4 kolom */
      text-align: center;
      transition: var(--transition-smooth);
    }

    .card-stat:hover {
      transform: translateY(-5px);
    }

    .card-stat h5 {
      font-size: 1.2rem;
      color: var(--cafe-dark);
      margin-bottom: 0.5rem;
    }

    .card-stat p {
      font-size: 1.5rem;
      font-weight: bold;
      color: var(--text-dark);
    }

    .nav-box {
      display: flex;
      flex-direction: column;
      gap: 20px;
    }

    .card-nav {
      background: var(--white);
      border-radius: var(--border-radius-lg);
      box-shadow: var(--shadow-light);
      padding: 1.5rem;
      text-align: center;
      transition: var(--transition-smooth);
    }

    .card-nav h5 {
      font-size: 1.2rem;
      color: var(--cafe-dark);
      margin-bottom: 0.5rem;
    }

    .card-nav a {
      color: var(--accent-gold);
      text-decoration: none;
      font-weight: 600;
    }

    .card-nav a:hover {
      text-decoration: underline;
    }

    @media (max-width: 768px) {
      .card-stat {
        flex: 1 1 calc(50% - 20px); /* Responsif untuk 2 kolom di mobile */
      }
    }

    @media (max-width: 480px) {
      .card-stat {
        flex: 1 1 100%; /* Responsif untuk 1 kolom di mobile */
      }
    }
  </style>
</head>
<body>
  <button class="btn-toggle-sidebar" onclick="toggleSidebar()">☰ Menu</button>
  <?php include '../layout/sidebar-admin.php'; ?> <!-- Include sidebar admin -->

  <div class="main-container">
    <div class="content">
      <h2 class="section-title">Dashboard Admin</h2>
      <p>Selamat datang, <?= htmlspecialchars($_SESSION['username']); ?>!</p>

      <div class="stat-box">
        <div class="card-stat">
          <h5>Transaksi Bulan Ini</h5>
          <p><?= $trx['total_transaksi'] ?? 0 ?></p>
        </div>
        <div class="card-stat">
          <h5>Omzet Bulan Ini</h5>
          <p>Rp <?= number_format($omzet['total_omzet'] ?? 0, 0, ',', '.') ?></p>
        </div>
        <div class="card-stat">
          <h5>Kasir Terdaftar</h5>
          <p><?= $user['total_user'] ?? 0 ?></p>
        </div>
        <div class="card-stat">
          <h5>Menu Tersedia</h5>
          <p><?= $menu['total_menu'] ?? 0 ?></p>
        </div>
      </div>

      <div class="nav-box">
        <div class="card-nav">
          <h5>☕ Kelola Menu</h5>
          <a href="menu.php">Lihat Menu</a>
        </div>
        <div class="card-nav">
          <h5>📈 Laporan Penjualan</h5>
          <a href="laporan.php">Lihat Laporan</a>
        </div>
        <div class="card-nav">
          <h5>👥 Manajemen User</h5>
          <a href="users.php">Kelola User</a>
        </div>
      </div>
    </div>
  </div>

  <script>
    function toggleSidebar() {
      document.querySelector(".sidebar").classList.toggle("active");
    }
  </script>
</body>
</html>
