<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'pegawai') {
    header("Location: login.php");
    exit;
}

include 'database/koneksi.php';

$id = $_GET['id'];
$q = mysqli_query($conn, "SELECT * FROM transaksi WHERE id='$id'");
$data = mysqli_fetch_assoc($q);

// Ambil detail item
$q_detail = mysqli_query($conn, "
    SELECT dt.*, m.nama_menu 
    FROM detail_transaksi dt 
    JOIN menu m ON m.id = dt.menu_id 
    WHERE dt.transaksi_id = '$id'
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Struk Pembayaran</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @media print {
      .no-print { display: none; }
    }
    .struk-box {
      max-width: 400px;
      margin: auto;
      padding: 20px;
      background: white;
      border: 1px solid #ccc;
      border-radius: 8px;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    .struk-header {
      text-align: center;
    }
    .struk-header h4 {
      margin-bottom: 0.5rem;
    }
    .struk-header p {
      margin-bottom: 1rem;
      font-size: 0.9rem;
      color: #555;
    }
    .struk-footer {
      text-align: center;
      margin-top: 20px;
    }
    .btn-custom {
      background: #007bff;
      color: white;
      border: none;
      padding: 0.5rem 1rem;
      border-radius: 5px;
      transition: background 0.3s;
    }
    .btn-custom:hover {
      background: #0056b3;
    }
  </style>
</head>
<body class="bg-light">

<div class="struk-box mt-5">
  <div class="struk-header">
    <h4>1Parade Store</h4>
    <p><?= date('d-m-Y H:i', strtotime($data['waktu_transaksi'])) ?></p>
    <hr>
  </div>
  
  <table class="w-100 mb-3">
    <?php while ($item = mysqli_fetch_assoc($q_detail)) { ?>
    <tr>
      <td><?= htmlspecialchars($item['nama_menu']) ?> x<?= $item['jumlah'] ?></td>
      <td class="text-end">Rp <?= number_format($item['subtotal'], 0, ',', '.') ?></td>
    </tr>
    <?php } ?>
  </table>
  
  <hr>
  
  <table class="w-100">
    <tr>
      <td><strong>Total</strong></td>
      <td class="text-end">Rp <?= number_format($data['total'], 0, ',', '.') ?></td>
    </tr>
    <tr>
      <td>Bayar</td>
      <td class="text-end">Rp <?= number_format($data['bayar'], 0, ',', '.') ?></td>
    </tr>
    <tr>
      <td>Kembali</td>
      <td class="text-end">Rp <?= number_format($data['kembalian'], 0, ',', '.') ?></td>
    </tr>
  </table>

  <div class="struk-footer no-print">
    <button onclick="window.print()" class="btn btn-custom w-100 mb-2">🖨️ Cetak Struk</button>
    <a href="kasir.php" class="btn btn-outline-secondary w-100">⬅️ Kembali ke Kasir</a>
  </div>
</div>

</body>
</html>
