<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'pegawai') {
    header("Location: login.php");
    exit;
}
include 'database/koneksi.php';

$kasir_id = $_SESSION['user_id'];
$tanggal = isset($_GET['tanggal']) ? $_GET['tanggal'] : date('Y-m-d');

// Ambil data transaksi
$query = "SELECT * FROM transaksi 
          WHERE kasir_id='$kasir_id' 
          AND DATE(waktu_transaksi) = '$tanggal' 
          ORDER BY waktu_transaksi DESC";
$result = mysqli_query($conn, $query);

// Ambil ringkasan pembayaran
$q_summary = mysqli_query($conn, "
    SELECT 
      SUM(CASE WHEN metode = 'QRIS' THEN total ELSE 0 END) AS total_qris,
      SUM(CASE WHEN metode = 'Tunai' THEN total ELSE 0 END) AS total_tunai,
      COUNT(*) AS total_transaksi
    FROM transaksi 
    WHERE kasir_id = '$kasir_id' AND DATE(waktu_transaksi) = '$tanggal'
");
$summary = mysqli_fetch_assoc($q_summary);
$total_keseluruhan = $summary['total_qris'] + $summary['total_tunai'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Transaksi - 1parade</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/kasir_unified.css">
    <link rel="stylesheet" href="assets/css/r_kasir.css">
</head>
<body>
  <button class="btn-toggle-sidebar" onclick="toggleSidebar()">☰ Menu</button>
  <?php include 'layout/sidebar.php'; ?>
<div class="main-container">    
    <div class="content riwayat-container">
        <div class="riwayat-header">
            <h1 class="riwayat-title">
                <i class="fas fa-history"></i> Riwayat Transaksi
            </h1>
            <div class="riwayat-date">
                <?= date('l, d F Y', strtotime($tanggal)) ?>
            </div>
        </div>

        <form method="GET" class="form-filter">
            <input type="date" name="tanggal" value="<?= $tanggal ?>" required>
            <button type="submit" class="btn-primary">
                <i class="fas fa-filter"></i> Filter
            </button>
        </form>

        <div class="summary-card">
            <h4 class="summary-title">
                <i class="fas fa-chart-bar"></i> Ringkasan Hari Ini
            </h4>
            <div class="summary-grid">
                <div class="summary-item">
                    <div class="summary-label">Total Transaksi</div>
                    <div class="summary-value"><?= $summary['total_transaksi'] ?></div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">QRIS</div>
                    <div class="summary-value">Rp <?= number_format($summary['total_qris'], 0, ',', '.') ?></div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Tunai</div>
                    <div class="summary-value">Rp <?= number_format($summary['total_tunai'], 0, ',', '.') ?></div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Total Pendapatan</div>
                    <div class="summary-value">Rp <?= number_format($total_keseluruhan, 0, ',', '.') ?></div>
                </div>
            </div>
        </div>

        <div class="transactions-list">
            <?php if (mysqli_num_rows($result) > 0): ?>
                <?php while ($trx = mysqli_fetch_assoc($result)): ?>
                    <div class="card-transaksi">
                        <div class="trx-header">
                            <span class="trx-id">
                                <i class="fas fa-receipt"></i> #<?= $trx['id'] ?>
                            </span>
                            <span class="trx-time">
                                <i class="fas fa-clock"></i> <?= date('H:i', strtotime($trx['waktu_transaksi'])) ?>
                            </span>
                        </div>
                        
                        <div class="trx-total">
                            <i class="fas fa-money-bill-wave"></i> 
                            Total: Rp <?= number_format($trx['total'], 0, ',', '.') ?>
                        </div>

                        <ul class="list-menu">
                            <?php
                            $q_detail = mysqli_query($conn, "
                                SELECT dt.*, m.nama_menu 
                                FROM detail_transaksi dt 
                                JOIN menu m ON m.id = dt.menu_id 
                                WHERE dt.transaksi_id = '{$trx['id']}'
                            ");
                            while ($item = mysqli_fetch_assoc($q_detail)):
                            ?>
                                <li class="menu-item">
                                    <span class="menu-name">
                                        <?= $item['nama_menu'] ?> x<?= $item['jumlah'] ?>
                                    </span>
                                    <span class="menu-price">
                                        Rp <?= number_format($item['subtotal'], 0, ',', '.') ?>
                                    </span>
                                </li>
                            <?php endwhile; ?>
                        </ul>

                        <div class="trx-footer">
                            <span class="payment-method">
                                <i class="fas fa-<?= $trx['metode'] === 'QRIS' ? 'qrcode' : 'money-bill' ?>"></i>
                                <?= $trx['metode'] ?>
                            </span>
                            <span class="payment-amount">
                                Bayar: Rp <?= number_format($trx['metode'] === 'QRIS' ? $trx['total'] : $trx['bayar'], 0, ',', '.') ?>
                            </span>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <h3>Belum ada transaksi</h3>
                    <p>Transaksi untuk tanggal <?= date('d F Y', strtotime($tanggal)) ?> belum ada.</p>
                </div>
            <?php endif; ?>
        </div>

        <div class="back-btn-container">
            <a href="kasir.php" class="btn-back">
                <i class="fas fa-arrow-left"></i> Kembali ke Kasir
            </a>
        </div>
    </div>
</div>

<script>
function updateClock() {
    const now = new Date();
    const jam = now.getHours().toString().padStart(2, '0');
    const menit = now.getMinutes().toString().padStart(2, '0');
    const clockElement = document.getElementById('clock');
    if (clockElement) {
        clockElement.textContent = `⏰ ${jam}:${menit}`;
    }
}

setInterval(updateClock, 1000);
updateClock();

// Auto refresh dengan kondisi yang lebih baik
let lastActivity = Date.now();
document.addEventListener('click', () => { lastActivity = Date.now(); });
document.addEventListener('keypress', () => { lastActivity = Date.now(); });

setInterval(() => {
    // Refresh hanya jika tab aktif dan tidak ada aktivitas dalam 30 detik
    if (document.visibilityState === "visible" && Date.now() - lastActivity > 30000) {
        location.reload();
    }
}, 60000); // Cek setiap 60 detik (1 menit)
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const toggleBtn = document.querySelector('.btn-toggle-sidebar');
    const sidebar = document.querySelector('.sidebar');
    
    toggleBtn.addEventListener('click', function() {
        sidebar.classList.toggle('active');
        
        // Optional: Ubah ikon saat sidebar terbuka/tertutup
        this.textContent = sidebar.classList.contains('active') ? '×' : '☰';
    });
});
</script>

</body>
</html>