<?php
$current_file = basename($_SERVER['PHP_SELF']);
?>

<div class="sidebar">
  <a href="../dashboard.php" class="brand">🧾 1PARADE</a>
  
  <!-- Link Admin -->
  <?php if ($_SESSION['role'] == 'admin'): ?>
    <a href="../admin/dashboard.php" class="<?= $current_file == 'dashboard.php' ? 'active' : '' ?>">
      <i>📊</i> Dashboard
    </a>
    <a href="../admin/menu.php" class="<?= $current_file == 'menu.php' ? 'active' : '' ?>">
      <i>☕</i> Kelola Menu
    </a>
    <a href="../admin/laporan.php" class="<?= $current_file == 'laporan.php' ? 'active' : '' ?>">
      <i>📈</i> Laporan
    </a>
    <a href="../admin/users.php" class="<?= $current_file == 'users.php' ? 'active' : '' ?>">
      <i>👥</i> Users
    </a>
  <?php endif; ?>

  <!-- Link Kasir -->
  <?php if ($_SESSION['role'] == 'pegawai'): ?>
    <a href="../kasir.php" class="<?= $current_file == 'kasir.php' ? 'active' : '' ?>">
      <i>💵</i> Kasir
    </a>
    <a href="../riwayat_kasir.php" class="<?= $current_file == 'riwayat_kasir.php' ? 'active' : '' ?>">
      <i>🕒</i> Riwayat
    </a>
  <?php endif; ?>

  <hr>
  <a href="../logout.php">
    <i>🚪</i> Logout
  </a>
  
  <div class="kasir-info">
    <small>👤 <?= htmlspecialchars($_SESSION['username']) ?></small>
    <small id="clock">⏰ --:--</small>
  </div>
</div>

<script>
// Auto-update jam sidebar
function updateClock() {
  const now = new Date();
  document.getElementById('clock').textContent = 
    `⏰ ${now.getHours().toString().padStart(2,'0')}:${now.getMinutes().toString().padStart(2,'0')}`;
}
setInterval(updateClock, 60000);
updateClock();
</script>
