<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'pegawai') {
    header("Location: login.php");
    exit;
}
include 'database/koneksi.php';

$kasir_id = $_SESSION['user_id'];
$tanggal = isset($_GET['tanggal']) && $_GET['tanggal'] != '' ? $_GET['tanggal'] : date('Y-m-d');

// Ringkasan transaksi
$q1 = mysqli_query($conn, "
  SELECT
    COUNT(DISTINCT t.id) AS jumlah_transaksi,
    SUM(dt.subtotal) AS total_penjualan
  FROM transaksi t
  JOIN detail_transaksi dt ON dt.transaksi_id = t.id
  WHERE t.kasir_id = '$kasir_id' AND DATE(t.waktu_transaksi) = '$tanggal'
");
$data1 = mysqli_fetch_assoc($q1);

// Total per metode pembayaran
$q_summary = mysqli_query($conn, "
  SELECT
    SUM(CASE WHEN metode = 'QRIS' THEN total ELSE 0 END) AS total_qris,
    SUM(CASE WHEN metode = 'Tunai' THEN total ELSE 0 END) AS total_tunai
  FROM transaksi
  WHERE kasir_id = '$kasir_id' AND DATE(waktu_transaksi) = '$tanggal'
");
$summary = mysqli_fetch_assoc($q_summary);

// Detail metode pembayaran
$q2 = mysqli_query($conn, "
  SELECT metode, COUNT(*) as jumlah, SUM(total) as total
  FROM transaksi
  WHERE kasir_id = '$kasir_id' AND DATE(waktu_transaksi) = '$tanggal'
  GROUP BY metode
");

// Semua menu dan jumlah terjual
$q_per_menu = mysqli_query($conn, "
  SELECT
    m.nama_menu,
    COALESCE(SUM(CASE WHEN DATE(t.waktu_transaksi) = '$tanggal' THEN dt.jumlah ELSE 0 END), 0) AS total_terjual,
    COALESCE(SUM(CASE WHEN DATE(t.waktu_transaksi) = '$tanggal' THEN dt.subtotal ELSE 0 END), 0) AS total_penjualan
  FROM menu m
  LEFT JOIN detail_transaksi dt ON m.id = dt.menu_id
  LEFT JOIN transaksi t ON t.id = dt.transaksi_id AND t.kasir_id = '$kasir_id'
  GROUP BY m.id
  ORDER BY total_penjualan DESC
");

// Total menu terjual
$q_total_menu = mysqli_query($conn, "
  SELECT SUM(dt.jumlah) AS total_menu_terjual
  FROM transaksi t
  JOIN detail_transaksi dt ON dt.transaksi_id = t.id
  WHERE t.kasir_id = '$kasir_id' AND DATE(t.waktu_transaksi) = '$tanggal'
");
$data_menu = mysqli_fetch_assoc($q_total_menu);
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Responsif -->
  <title>Closing Penjualan</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/r_kasir.css"> <!-- Link ke file CSS terpisah -->
  <link rel="stylesheet" href="assets/css/kasir_unified.css"> <!-- Link ke file CSS utama -->
  <style>
    /* Custom styles for closing kasir */
    .summary-card {
      background: var(--white);
      border-radius: var(--border-radius-lg);
      box-shadow: var(--shadow-light);
      padding: 1.5rem;
      margin-bottom: 1.5rem;
    }

    .summary-title {
      font-size: 1.5rem;
      font-weight: 600;
      margin-bottom: 1rem;
    }

    .summary-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 1rem;
    }

    .summary-item {
      background: var(--cream);
      border-radius: var(--border-radius);
      padding: 1rem;
      text-align: center;
    }

    .summary-value {
      font-size: 1.5rem;
      font-weight: 700;
      color: var(--cafe-dark);
    }

    .summary-label {
      color: var(--text-medium);
      font-size: 1rem;
    }

    .btn-custom {
      background: var(--accent-gold);
      color: var(--white);
      border: none;
      padding: 0.5rem 1rem;
      border-radius: var(--border-radius);
      transition: background 0.3s;
    }

    .btn-custom:hover {
      background: var(--accent-gold-hover);
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
      .summary-grid {
        grid-template-columns: 1fr;
      }
    }
  </style>
</head>
<body>
  <!-- Button to toggle sidebar -->
  <button class="btn-toggle-sidebar" onclick="toggleSidebar()">☰ Menu</button>
  
  <?php include 'layout/sidebar.php'; ?>
  
  <div class="main-container">
    <div class="content">
      <h3 class="mb-4">📊 Closing Penjualan - <?= htmlspecialchars($_SESSION['username']) ?> (<?= $tanggal ?>)</h3>

      <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
          <input type="date" name="tanggal" class="form-control" value="<?= htmlspecialchars($tanggal) ?>">
        </div>
        <div class="col-md-2">
          <button class="btn btn-custom w-100">Tampilkan</button>
        </div>
      </form>

      <!-- Ringkasan -->
      <div class="summary-card">
        <h5 class="summary-title">Ringkasan</h5>
        <div class="summary-grid">
          <div class="summary-item">
            <div class="summary-label">Total Penjualan</div>
            <div class="summary-value">Rp <?= number_format($data1['total_penjualan'] ?? 0, 0, ',', '.') ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Jumlah Transaksi</div>
            <div class="summary-value"><?= $data1['jumlah_transaksi'] ?? 0 ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Total QRIS</div>
            <div class="summary-value">Rp <?= number_format($summary['total_qris'] ?? 0, 0, ',', '.') ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Total Tunai</div>
            <div class="summary-value">Rp <?= number_format($summary['total_tunai'] ?? 0, 0, ',', '.') ?></div>
          </div>
          <div class="summary-item">
            <div class="summary-label">Jumlah Menu Terjual</div>
            <div class="summary-value"><?= $data_menu['total_menu_terjual'] ?? 0 ?></div>
          </div>
        </div>
      </div>

      <!-- Metode Pembayaran -->
      <div class="card shadow-sm mb-4">
        <div class="card-body">
          <h5 class="card-title">Detail Metode Pembayaran</h5>
          <ul class="list-group">
            <?php while ($row = mysqli_fetch_assoc($q2)) { ?>
              <li class="list-group-item d-flex justify-content-between">
                <?= htmlspecialchars($row['metode']) ?>
                <span><?= $row['jumlah'] ?>x - Rp <?= number_format($row['total'], 0, ',', '.') ?></span>
              </li>
            <?php } ?>
          </ul>
        </div>
      </div>

      <!-- Daftar Menu -->
      <div class="card shadow-sm mb-4">
        <div class="card-body">
          <h5 class="card-title">Daftar Menu dan Jumlah Terjual</h5>
          <div class="table-responsive">
            <table class="table table-bordered table-sm">
              <thead class="table-light">
                <tr>
                  <th>Nama Menu</th>
                  <th>Jumlah Terjual</th>
                  <th>Total Penjualan</th>
                </tr>
              </thead>
              <tbody>
                <?php while ($row = mysqli_fetch_assoc($q_per_menu)) { ?>
                  <tr>
                    <td><?= htmlspecialchars($row['nama_menu']) ?></td>
                    <td><?= $row['total_terjual'] ?>x</td>
                    <td>Rp <?= number_format($row['total_penjualan'], 0, ',', '.') ?></td>
                  </tr>
                <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <div class="text-end">
        <a href="kasir.php" class="btn btn-outline-dark">⬅️ Kembali ke Kasir</a>
      </div>
    </div>
  </div>

  <script>
    function updateClock() {
      const now = new Date();
      const jam = now.getHours().toString().padStart(2, '0');
      const menit = now.getMinutes().toString().padStart(2, '0');
      document.getElementById('clock').textContent = `⏰ ${jam}:${menit}`;
    }

    setInterval(updateClock, 1000);
    updateClock();

    // Toggle sidebar function
    function toggleSidebar() {
      const sidebar = document.querySelector('.sidebar');
      sidebar.classList.toggle('active');
    }
  </script>
</body>
</html>
