let total = 0;
let orders = [];

function tambahPesanan(id, nama, harga) {
  const existing = orders.find(item => item.id === id);
  if (existing) {
    existing.qty++;
  } else {
    orders.push({ id, nama, harga, qty: 1 });
  }
  renderOrder();
}

// Fungsi untuk mengurangi jumlah pesanan
function kurangPesanan(id) {
  const existing = orders.find(item => item.id === id);
  if (existing) {
    existing.qty--;
    if (existing.qty <= 0) {
      hapusPesanan(id); // Hapus jika jumlahnya 0 atau kurang
    }
  }
  renderOrder();
}

function hapusPesanan(id) {
  orders = orders.filter(item => item.id !== id);
  renderOrder();
}

function renderOrder() {
  const orderList = document.getElementById("orderList");
  orderList.innerHTML = "";
  total = 0;
  orders.forEach(item => {
    const subtotal = item.harga * item.qty;
    total += subtotal;
    // Menggunakan struktur HTML yang sesuai dengan kasir_unified.css
    orderList.innerHTML += `
      <div class="order-item fade-in">
        <div class="order-item-info">
          <div class="order-item-name">${item.nama}</div>
          <div class="order-item-price">Rp ${item.harga.toLocaleString('id-ID')}</div>
        </div>
        <div class="order-item-controls">
          <button class="qty-btn" onclick="kurangPesanan(${item.id})">-</button>
          <span class="qty-display">${item.qty}</span>
          <button class="qty-btn" onclick="tambahPesanan(${item.id}, '${item.nama}', ${item.harga})">+</button>
          <span class="order-item-price">Rp ${subtotal.toLocaleString('id-ID')}</span>
          <button class="qty-btn" onclick="hapusPesanan(${item.id})" style="background-color: var(--error);"><i class='fas fa-times'></i></button>
        </div>
      </div>`;
  });
  document.getElementById("total").innerText = total.toLocaleString('id-ID');
  hitungKembalian();
}

function hitungKembalian() {
  const uangInput = document.getElementById("uang");
  const uang = parseInt(uangInput.value) || 0;
  const kembali = uang - total;
  const tampil = document.getElementById("kembalian");

  if (kembali >= 0) {
    tampil.innerText = "Kembalian: Rp " + kembali.toLocaleString('id-ID');
    tampil.classList.add('show'); // Tampilkan kembalian
    tampil.style.backgroundColor = 'var(--success)'; // Warna hijau untuk kembalian positif
  } else {
    tampil.innerText = "Kurang: Rp " + Math.abs(kembali).toLocaleString('id-ID');
    tampil.classList.add('show'); // Tampilkan kembalian
    tampil.style.backgroundColor = 'var(--error)'; // Warna merah untuk kurang
  }

  if (uang === 0 && total === 0) { // Sembunyikan jika tidak ada transaksi
    tampil.classList.remove('show');
  }
}


function bayar() {
  const metode = document.getElementById("metode_pembayaran").value;
  const uang = parseInt(document.getElementById("uang").value) || 0;
  const kembali = uang - total;

  if (orders.length === 0) {
    alert("Belum ada menu yang dipesan.");
    return;
  }

  if (metode === "Tunai" && uang < total) {
    alert("Uang tidak cukup untuk pembayaran.");
    return;
  }

  const items = orders.map(item => ({
    menu_id: item.id,
    jumlah: item.qty,
    subtotal: item.harga * item.qty
  }));

  fetch("proses.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({
      total: total,
      bayar: uang,
      kembalian: kembali,
      metode: metode,
      items: items
    })
  })
  .then(res => res.json())
  .then(res => {
    if (res.success) {
      alert("Transaksi berhasil! Total: Rp " + total.toLocaleString('id-ID'));
      // Redirect ke struk setelah pembayaran berhasil
      window.location.href = `struk.php?id=${res.id_transaksi}`;
      
      // Reset order (ini akan dieksekusi setelah redirect, jadi mungkin tidak terlalu terlihat)
      orders = [];
      total = 0;
      document.getElementById("uang").value = "";
      document.getElementById("kembalian").innerText = "";
      renderOrder();
    } else {
      alert("Gagal menyimpan transaksi: " + res.message);
    }
  })
  .catch(err => {
    console.error(err);
    alert("Terjadi kesalahan saat menyimpan transaksi.");
  });
}

document.getElementById("searchMenu").addEventListener("keyup", function () {
  const keyword = this.value.toLowerCase();
  const cards = document.querySelectorAll(".menu-card");
  cards.forEach(card => {
    const title = card.querySelector("h4").textContent.toLowerCase();
    card.style.display = title.includes(keyword) ? "flex" : "none"; // Gunakan flex karena menu-card di CSS pakai flex
  });
});

document.getElementById("metode_pembayaran").addEventListener("change", function () {
  const metode = this.value;
  const totalText = document.getElementById("total").textContent.replace(/\./g, '').replace(/Rp /g, ''); // Hapus "Rp " dan titik
  const total = Number(totalText) || 0;

  if (metode === "QRIS") {
    document.getElementById("uang").value = total;
    hitungKembalian();
  } else {
    document.getElementById("uang").value = "";
    hitungKembalian();
  }
});

window.addEventListener("DOMContentLoaded", () => {
  const grid = document.querySelector(".grid");
  const cards = Array.from(grid.querySelectorAll(".menu-card"));

  // Sortir menu berdasarkan nama secara default
  cards.sort((a, b) => {
    const nameA = a.querySelector("h4").textContent.toLowerCase();
    const nameB = b.querySelector("h4").textContent.toLowerCase();
    return nameA.localeCompare(nameB);
  });

  cards.forEach(card => grid.appendChild(card));
  renderOrder(); // Render order saat halaman dimuat untuk memastikan tampilan awal
});

