<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit;
}
include '../database/koneksi.php';

$upload_dir = '../uploads/';
if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

// Handle tambah menu
if (isset($_POST['tambah'])) {
    $nama = $_POST['nama_menu'];
    $harga = $_POST['harga'];

    $gambar = $_FILES['gambar']['name'];
    $tmp = $_FILES['gambar']['tmp_name'];
    $type = $_FILES['gambar']['type'];
    $size = $_FILES['gambar']['size'];

    $allowed = ['image/jpeg', 'image/png', 'image/jpg', 'image/webp'];
    $gambar_final = "default.png"; // Default jika tidak upload gambar

    if (!empty($gambar)) {
        if (!in_array($type, $allowed)) {
            echo "<script>alert('Format gambar tidak didukung.'); window.history.back();</script>";
            exit;
        }
        if ($size > 2 * 1024 * 1024) {
            echo "<script>alert('Ukuran gambar maksimal 2MB'); window.history.back();</script>";
            exit;
        }

        $gambar_final = uniqid() . "-" . basename($gambar);
        move_uploaded_file($tmp, $upload_dir . $gambar_final);
    }

    // Menggunakan prepared statement untuk INSERT
    $stmt = mysqli_prepare($conn, "INSERT INTO menu (nama_menu, harga, gambar) VALUES (?, ?, ?)");
    mysqli_stmt_bind_param($stmt, "sis", $nama, $harga, $gambar_final);
    mysqli_stmt_execute($stmt) or die(mysqli_error($conn)); // Sementara pakai die, nanti kita refactor error handlingnya
    mysqli_stmt_close($stmt);

    header("Location: menu.php");
    exit;
}

// Handle hapus menu
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    
    // Menggunakan prepared statement untuk SELECT
    $cek_stmt = mysqli_prepare($conn, "SELECT id FROM detail_transaksi WHERE menu_id=?");
    mysqli_stmt_bind_param($cek_stmt, "i", $id);
    mysqli_stmt_execute($cek_stmt);
    mysqli_stmt_store_result($cek_stmt);

    if (mysqli_stmt_num_rows($cek_stmt) > 0) {
        echo "<script>alert('Menu tidak bisa dihapus karena sudah digunakan di transaksi!');window.location='menu.php';</script>";
        mysqli_stmt_close($cek_stmt);
        exit;
    }
    mysqli_stmt_close($cek_stmt);

    // Menggunakan prepared statement untuk DELETE
    $del_stmt = mysqli_prepare($conn, "DELETE FROM menu WHERE id=?");
    mysqli_stmt_bind_param($del_stmt, "i", $id);
    mysqli_stmt_execute($del_stmt) or die(mysqli_error($conn)); // Sementara pakai die
    mysqli_stmt_close($del_stmt);

    header("Location: menu.php");
    exit;
}

// Handle edit menu
if (isset($_GET['edit'])) {
    $id = $_GET['edit'];
    // Menggunakan prepared statement untuk SELECT edit
    $edit_stmt = mysqli_prepare($conn, "SELECT * FROM menu WHERE id=?");
    mysqli_stmt_bind_param($edit_stmt, "i", $id);
    mysqli_stmt_execute($edit_stmt);
    $result_edit = mysqli_stmt_get_result($edit_stmt);
    $edit = mysqli_fetch_assoc($result_edit);
    mysqli_stmt_close($edit_stmt);
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Menu - 1Parade</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/kasir_unified.css"> <!-- Gunakan CSS yang sama -->
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
        }
        .main-container {
            display: flex;
            flex-direction: column;
            padding: 20px;
        }
        .content {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .section-title {
            font-size: 2rem;
            font-weight: 600;
            color: #7a4b32; /* Warna aksen kopi */
            margin-bottom: 20px;
        }
        .card {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .form-control {
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            width: 100%;
            margin-bottom: 10px;
        }
        .btn-add-menu {
            background-color: #7a4b32; /* Warna aksen kopi */
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            font-size: 16px;
            width: 100%;
        }
        .btn-add-menu:hover {
            background-color: #6b3e2a; /* Warna lebih gelap saat hover */
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .table th, .table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        .table th {
            background-color: #7a4b32; /* Warna aksen kopi */
            color: white;
        }
        .table tbody tr:hover {
            background-color: #f1f1f1;
        }
        @media (max-width: 768px) {
            .form-control {
                font-size: 14px;
            }
            .btn-add-menu {
                font-size: 14px;
            }
            .table th, .table td {
                font-size: 14px;
            }
            .section-title {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <button class="btn-toggle-sidebar" onclick="toggleSidebar()">☰ Menu</button>
    <?php include '../layout/sidebar-admin.php'; ?> <!-- Include sidebar admin -->

    <div class="main-container">
        <div class="content">
            <h2 class="section-title">🧾 Manajemen Menu</h2>

            <!-- Form Tambah Menu -->
            <div class="card">
                <h5 class="card-title"><?= isset($edit) ? 'Edit Menu' : 'Tambah Menu Baru' ?></h5>
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="id" value="<?= isset($edit) ? $edit['id'] : '' ?>">
                    <input type="text" name="nama_menu" class="form-control" placeholder="Nama Menu" required value="<?= isset($edit) ? htmlspecialchars($edit['nama_menu']) : '' ?>">
                    <input type="number" name="harga" class="form-control" placeholder="Harga" required value="<?= isset($edit) ? htmlspecialchars($edit['harga']) : '' ?>">
                    <input type="file" name="gambar" class="form-control" accept="image/*">
                    <?php if (isset($edit) && $edit['gambar'] && $edit['gambar'] != 'default.png') { ?>
                        <small class="text-muted">Gambar saat ini:</small>
                        <img src="../uploads/<?= htmlspecialchars($edit['gambar']) ?>" width="80" class="mt-1 rounded">
                    <?php } ?>
                    <button type="submit" class="btn-add-menu" name="<?= isset($edit) ? 'edit' : 'tambah' ?>">
                        <?= isset($edit) ? 'Update Menu' : 'Tambah Menu' ?>
                    </button>
                </form>
            </div>

            <!-- Tabel Daftar Menu -->
            <div class="card">
                <h5 class="card-title">Daftar Menu Tersedia</h5>
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Gambar</th>
                            <th>Nama Menu</th>
                            <th>Harga</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $menu = mysqli_query($conn, "SELECT * FROM menu ORDER BY id DESC");
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($menu)) {
                        ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td>
                                <?php if (!empty($row['gambar']) && $row['gambar'] != 'default.png') { ?>
                                    <img src="../uploads/<?= htmlspecialchars($row['gambar']) ?>" width="60" height="60" style="object-fit: cover;">
                                <?php } else { ?>
                                    <img src="https://via.placeholder.com/60x60?text=No+Image" width="60" height="60" style="object-fit: cover;">
                                <?php } ?>
                            </td>
                            <td><?= htmlspecialchars($row['nama_menu']) ?></td>
                            <td>Rp <?= number_format($row['harga'], 0, ',', '.') ?></td>
                            <td>
                                <a href="menu.php?edit=<?= $row['id'] ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <a href="menu.php?hapus=<?= $row['id'] ?>" onclick="return confirm('Yakin mau hapus menu ini?')" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash-alt"></i> Hapus
                                </a>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>
